/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.logistics.item.filter.attribute.attributes;

import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.zurrtum.create.AllItemAttributeTypes;
import com.zurrtum.create.catnip.codecs.stream.CatnipStreamCodecBuilders;
import com.zurrtum.create.content.logistics.item.filter.attribute.ItemAttribute;
import com.zurrtum.create.content.logistics.item.filter.attribute.ItemAttributeType;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.function.Predicate;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2371;
import net.minecraft.class_2480;
import net.minecraft.class_2561;
import net.minecraft.class_3542;
import net.minecraft.class_9129;
import net.minecraft.class_9139;
import net.minecraft.class_9288;
import net.minecraft.class_9334;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record ShulkerFillLevelAttribute(ShulkerLevels levels) implements ItemAttribute
{
    public static final MapCodec<ShulkerFillLevelAttribute> CODEC = ShulkerLevels.CODEC.xmap(ShulkerFillLevelAttribute::new, ShulkerFillLevelAttribute::levels).fieldOf("value");
    public static final class_9139<ByteBuf, ShulkerFillLevelAttribute> PACKET_CODEC = ShulkerLevels.STREAM_CODEC.method_56432(ShulkerFillLevelAttribute::new, ShulkerFillLevelAttribute::levels);

    @Override
    public boolean appliesTo(class_1799 stack, class_1937 level) {
        return this.levels != null && this.levels.canApply(stack);
    }

    @Override
    public String getTranslationKey() {
        return "shulker_level";
    }

    @Override
    public Object[] getTranslationParameters() {
        String parameter = "";
        if (this.levels != null) {
            parameter = class_2561.method_43471((String)("create.item_attributes." + this.getTranslationKey() + "." + this.levels.key)).getString();
        }
        return new Object[]{parameter};
    }

    @Override
    public ItemAttributeType getType() {
        return AllItemAttributeTypes.SHULKER_FILL_LEVEL;
    }

    static enum ShulkerLevels implements class_3542
    {
        EMPTY("empty", amount -> amount == 0),
        PARTIAL("partial", amount -> amount > 0 && amount < Integer.MAX_VALUE),
        FULL("full", amount -> amount == Integer.MAX_VALUE);

        public static final Codec<ShulkerLevels> CODEC;
        public static final class_9139<ByteBuf, ShulkerLevels> STREAM_CODEC;
        private final Predicate<Integer> requiredSize;
        private final String key;

        private ShulkerLevels(String key, Predicate<Integer> requiredSize) {
            this.key = key;
            this.requiredSize = requiredSize;
        }

        @Nullable
        public static ShulkerLevels fromKey(String key) {
            return Arrays.stream(ShulkerLevels.values()).filter(shulkerLevels -> shulkerLevels.key.equals(key)).findFirst().orElse(null);
        }

        private static boolean isShulker(class_1799 stack) {
            return class_2248.method_9503((class_1792)stack.method_7909()) instanceof class_2480;
        }

        public String method_15434() {
            return this.name().toLowerCase(Locale.ROOT);
        }

        public boolean canApply(class_1799 testStack) {
            if (!ShulkerLevels.isShulker(testStack)) {
                return false;
            }
            class_9288 contents = (class_9288)testStack.method_58695(class_9334.field_49622, (Object)class_9288.field_49334);
            if (contents == class_9288.field_49334) {
                return this.requiredSize.test(0);
            }
            if (testStack.method_57826(class_9334.field_49626)) {
                return false;
            }
            if (!contents.field_49338.isEmpty()) {
                int rawSize = contents.field_49338.size();
                if (rawSize < 27) {
                    return this.requiredSize.test(rawSize);
                }
                class_2371 inventory = class_2371.method_10213((int)27, (Object)class_1799.field_8037);
                contents.method_57492(inventory);
                boolean isFull = inventory.stream().allMatch(itemStack -> !itemStack.method_7960() && itemStack.method_7947() == itemStack.method_7914());
                return this.requiredSize.test(isFull ? Integer.MAX_VALUE : rawSize);
            }
            return this.requiredSize.test(0);
        }

        static {
            CODEC = class_3542.method_28140(ShulkerLevels::values);
            STREAM_CODEC = CatnipStreamCodecBuilders.ofEnum(ShulkerLevels.class);
        }
    }

    public static class Type
    implements ItemAttributeType {
        @Override
        @NotNull
        public ItemAttribute createAttribute() {
            return new ShulkerFillLevelAttribute(null);
        }

        @Override
        public List<ItemAttribute> getAllAttributes(class_1799 stack, class_1937 level) {
            ArrayList<ItemAttribute> list = new ArrayList<ItemAttribute>();
            for (ShulkerLevels shulkerLevels : ShulkerLevels.values()) {
                if (!shulkerLevels.canApply(stack)) continue;
                list.add(new ShulkerFillLevelAttribute(shulkerLevels));
            }
            return list;
        }

        @Override
        public MapCodec<? extends ItemAttribute> codec() {
            return CODEC;
        }

        @Override
        public class_9139<? super class_9129, ? extends ItemAttribute> packetCodec() {
            return PACKET_CODEC;
        }
    }
}

